/* VT.H - VT decoder definitions. */

#if defined(_CONSOLE)
#include    <windows.h>

void gotoxy(int,int) ;
void clreol(void) ;
int ConsoleInit(void) ;
#endif

#define VT_ROWS 24              /* # of rows */
#define VT_COLS 80              /*  and columns in a screen */
#define VT_NARGS    30          /* max args in ESC. seq. */
#define VT_OUTBUF_SIZE  512         /* max output size */

#define SET 0               /* mode SET */
#define RESET   1               /* mode RESET */

#define VTID_Z      0           /* ESC-Z terminal ID */
typedef unsigned char SCREEN ;          /* what a screen is */

struct field {
    struct  field *next ;           /* -> next one */
    int row ;               /* row */
    int lcol ;              /* leftmost column */
    int rcol ;              /* rightmost column */
    int (*routine)() ;          /* modify routine */
} ;

struct vt_info {
    int initialized ;           /* true if initialized */
    char state ;                /* current state */
    int row ;               /* current row */
    int col ;               /*  and column */
    int rows ;              /* # of rows (narrow) */
    int cols ;              /* # of columns (narrow) */
    int wrows ;             /* # of rows (wide) */
    int wcols ;             /* # of columns (wide) */
    int save_row ;              /* saved row */
    int save_col ;              /*  and column */
    int altchar ;               /* true if in alternate charset */
    int args[VT_NARGS] ;            /* argument list */
    int arg ;               /* current argument index */
    int last_ch ;               /* last character seen */
    char tabs[VT_COLS+1] ;          /* tab stops */
    char wide_mode ;            /* wide mode (SET/RESET) */
    SCREEN screen[VT_ROWS+1][VT_COLS+1] ;   /* the screen */
    struct field *first_field ;     /* -> first field */
    struct field *last_field ;      /* -> last field */
    int (*termid)() ;           /* default identifier */
    void (*tty_input)(void *,char *,int) ;
    void *pvInputParam ;
#if defined(VIA_SMG) || defined(_CONSOLE)
    char *outbuf ;
#if defined(_CONSOLE)
    CONSOLE_SCREEN_BUFFER_INFO ScreenInfo ;
#endif
    int pasteboard_id ;         /* associated SMG pbd. id */
    int display_id ;            /* associated SMG display id */
    int rendition ;             /* display rendition */
    int charset[4] ;            /* G0-G3 character sets */
#define G0  0
#define G1  1
#define G2  2
#define G3  3
    int cs_index ;              /* charset index */
    int save_cs_index ;         /* for SS2, SS3 (later) */
    int scr_top, scr_bottom ;       /* top/bottom of scroll reg. */
#endif
} ;

#define VS_CHAR     0
#define VS_ESCSEQ   1
#define VS_CHARSET  2
#define VS_CSIQUES  3

#define ESC 27
#define CSI '['
/*
 * this is a nasty thing.  vtdecode() gets an extra arg if using SMG.
 */
int vtdecode(
#ifdef VIA_SMG
    struct dm_window *,
#endif
    struct vt_info *,unsigned char *,int) ;
