#! /usr/local/bin/perl
#
#   Make wrappers for Perl scripts
#

$perlwrap = "perlwrap.exe";

$copy_cmd = "COPY /y";

$ego = $0;
$ego =~ s/.*[\\\/]//;
$ego =~ s/[.][^.]*$//i;

$egodir = $0;
$egodir =~ s/[\\\/][^\\\/]+$//;
$egodir =~ s/[\\]/\//g;

if ($ARGV[0] eq '') {
	print STDERR "usage: $ego file1.pl [file2.pl ...]\n";
	exit(1);
}

sub find_exe {
	$s = $perlwrap;
	return $s if (-f $s);
	$s = "$base_dir$perlwrap";
	return $s if (-f $s);
	$ss = "$egodir/$perlwrap";
	return $ss if (-f $ss);
	print "$ego: Can't locate Perl wrapper executable ($s or $ss)!\n";
	exit(1);
}

while ($ARGV[0]) {
	$script = shift(@ARGV);
	###print "$script\n";
	if ($script =~ /^(.*)[.]pl$/i) {
		$base = $1;
		$base_dir = $base;
		$base_dir =~ s/[^\\\/]+$//;
		$source = &find_exe;

		$target = "$base.exe";
		$target =~ s/[\\]/\//g;
		if (-f $target) {
			print "$ego: $target exists...skipping $base!\n";
		} else {
			$cmd = "$source $target";
			$cmd =~ s/[\/]/\\/g;
			$cmd = "$copy_cmd $cmd";
			print "$cmd\n";
			$x = `$cmd`;
			print "$result" if ($result);
		}
	} else {
		print "$ego: Perl script '$script' must end in '.pl'!\n";
	}
}
