#!/usr/local/bin/perl
 
#------------------------ nslookup --------------------------------------
 
if ($ARGV[0] =~ /^[0-9]/)  { # digit - ip address
    print "Reverse lookup for $ARGV[0]\n" ;
    $addr = pack("C4",split(/\./,$ARGV[0])) ;
    ($name,$aliases) = gethostbyaddr($addr,2) ;
    if ($name ne "")  {
        print STDOUT "$ARGV[0]\t$name $aliases\n" ;
    }
    else  {
        print STDERR "No match for $ARGV[0]\n" ;
    }
}
else  {
    print "Looking up hostname $ARGV[0]\n" ;
    ($name,$aliases,$addrtype,$length,@addrs) = gethostbyname($ARGV[0]) ;
    if ($aliases ne "")  {
        $aliases = ' '.$aliases ;
    }
    print "$name$aliases:" ;
    if ($#addrs > 0)  {         # more than 1 address
        print "\n" ;
    }
    for ($i=0 ; $i<=$#addrs ; $i++)  {
        print "\t" if (($i&3) == 0) ;
        ($a1,$a2,$a3,$a4) = unpack("C4",$addrs[$i]) ;
        print "$a1.$a2.$a3.$a4\t" ;
        print "\n" if (($i&3) == 3) ;
    }
    print "\n" ;
}
