#! /usr/local/bin/perl
# 
#  Volume in drive D has no label
#  Directory of D:\LIGHTNER\freyder\telnetd
# 
# .              <DIR>        02-28-98  9:44a .
# ..             <DIR>        02-28-98  9:44a ..
# CAT      EXE        17,408  03-01-98  5:31p cat.exe
# CAT      PL             88  05-13-98 11:04a cat.pl
# X                        0  05-16-98  9:16a x
#         47 file(s)      4,078,941 bytes
#          4 dir(s)      29,523,968 bytes free
#

$show_exts = 0;
$tolower = 1;
$recurse = 1;
$show_long = 0;
$time_sort = 0;
$reverse = 0;

while ($ARGV[0] =~ /^-/) {
	$opts = $ARGV[0];
	for ($ix = 1; $ix < length($opts); ++$ix) {
		$ch = substr($opts, $ix, 1);
		$show_exts = 1 if ($ch eq 'F');
		$recurse = 0 if ($ch eq 'd');
		$show_long = 1 if ($ch eq 'l');
		$time_sort = 1 if ($ch eq 't');
		$reverse = 1 if ($ch eq 'r');
	}
	shift @ARGV;
}

undef %sort_list;
if ($ARGV[0] eq '') {
	&do_one('', $recurse);
} else {
	while ($ARGV[0]) {
		&do_one($ARGV[0], $recurse);
		shift @ARGV;
	}
}

if ($time_sort) {
	if (!$reverse) {
		for $key (sort{$b cmp $a;} (keys %sort_list)) {
			print "$sort_list{$key}";
		}
	} else {
		for $key (sort(keys %sort_list)) {
			print "$sort_list{$key}";
		}
	}
}
exit;

sub show_possible_dir($file) {
	local($file) = @_;

	if ($show_exts && (-d $file)) {
		&show($file, '/');
	} else {
		&show($file);
	}
}

sub do_one {
	local($file, $recurse) = @_;

	if ($file eq '') {
		$file = '.';
		$dir = '';
	} else {
		$dir = "$file/";
	}
	if ($recurse && (-d $file)) {
		if (opendir(D,"$file"))  {
			undef @files ;  # be safe
			while (defined($t=readdir(D)))  {
				next if (substr($t,0,1) eq '.');
				$t =~ tr/[A-Z]/[a-z]/ if ($tolower);
				push(@files, $t);
			}
			closedir(D);
			foreach $t (sort (@files)) {
				&show_possible_dir("$dir$t");
			}
		} else {
			&show("$dir$file", '/');
		}
	} else {
		if (-f $file || -d $file) {
			&show_possible_dir($file);
		} else {
			print STDERR "$file not found\n";
		}
	}
}

sub show {
	local($file, $type) = @_;

	$file =~ tr/[A-Z]/[a-z]/ if ($tolower);
	if ($show_exts) {
		if ($type eq '') {
			$type = '*' if ($file =~ /[.]exe$/i);
			$type = '*' if ($file =~ /[.]com$/i);
			$type = '*' if ($file =~ /[.]bat$/i);
		}
		&list_file($file, $type);
	} else {
		&list_file($file, '');
	}
}

sub list_file {
	local($file, $type) = @_;

	if (!$show_long) {
		$s = "$file$type\n";
	} else {
		(@stats) = stat($file);
		$ftime = &localtime($stats[9]);
		$fsize = $stats[7];
		$fname = "$file$type";
		$s = sprintf("%9d %s %s\n", $fsize, $ftime, $fname);
	}
	if (!$time_sort) {
		print $s;
	} else {
		$key = "$stats[9]$file";
		$sort_list{$key} = $s;
	}
}

sub localtime {
	($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) =
		localtime(@_[0]) ;
	$monx = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec')[$mon];
	$wdayx = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat')[$wday];
	# Wed, 25 Feb 1998 22:05:53
	return sprintf("%s, %02d %s %d %02d:%02d:%02d",$wdayx,$mday,$monx,$year+1900,$hour,$min,$sec) ;
}
