/* DISPLAY.H - Display definitions. */

#include    <sys/types.h>       /* standard types */

#if defined(_CONSOLE)
#undef far
#define far
#include "conlib.h"
#endif

void cls() ;                /* clear screen */
void scrolling_region(int r1,int r2) ;      /* set scrolling region */
void row_col(int row,int col) ;     /* set row/column */
void clear_rows(int r1,int r2) ;    /* clear some rows */
/*
 * printf() fragments to do various ANSI things.
 */
#define SETCUR  "\033[%d;%dH"       /* set cursor row/col */
#define SR  "\033[%d;%dr"       /* set scrolling region */
#define SAVCUR  "\0337"         /* save cursor/attributes */
#define RSTCUR  "\0338"         /* restore cursor/attributes */
#define REVIDX  "\033M"         /* reverse index */
#define CLS "\033[H\033[J"      /* clear entire screen */
#define CLREOL  "\033[K"        /* clear to end of line */
#define CLRBOL  "\033[1K"       /* clear BOL to cursor */
#define CLRCHR  "\033[%dD"      /* clear characters right */
#define BS  "\010"          /* backspace */
#define SETMODE "\033[%dm"              /* set mode */
#define NORMMODE "\033[0m"      /* normal mode (white probably) */

#define PART_FMT    "%9lu"      /* part number format control */
#define PRICE_FMT       "%8.2lf"
#define PRICE_WIDTH     8

#define PL_PROMPT_ROW       1
#define PL_PROMPT_COL       2
#define PL_SCROLL_TOP       6
#define PL_SCROLL_BOTTOM    37
#define PL_INPUT_MAX        40
#define PL_MSG_ROW      (PL_SCROLL_TOP-2)   /* row for messages */
#define PL_MSG_WIDTH        59              /* max message width */
#define PL_SCROLL_MAX      500              /* max rollback lines to save */

#define PD_ROW  (PL_SCROLL_TOP+1)
#define PD_COL  1
#define PD_PPL  4           /* parts per line */

#define TIM_ROW PL_MSG_ROW
#define TIM_COL 60

char *current_time(void) ;      /* current time getter */
char *xdate(char *,time_t) ;        /* generalized date converter */
char *xdate_time(char *,time_t) ;       /* generalized date/time converter */
void cls(void) ;                        /* clear screen */
void beep(void) ;

extern void (far *scroll_rtn)(int row) ;    /* scroll routine in vtsubs.asm */

int msg(char *,...) ;
