/*  
* Program TIME_INT.C  
*  
  
Uses interrupt service routine to note interrupt from printer port.  
The interrupt is caused by a negative on /ACK input on Printer Port.  
  
Calculates time and displays the time in ms between interrupts.  
  
* P.H. Anderson, MSU, 10 Jan, '96  
*/  
  
#include <stdio.h>  
#include <bios.h>  
#include <dos.h>  
#include <sys\timeb.h>  
  
#define DATA 0x0378  
#define STATUS DATA+1  
#define CONTROL DATA+2  
  
#define TRUE 1  
#define FALSE 0  
  
void open_intserv(void);  
void close_intserv(void);  
void int_processed(void);  
void interrupt far intserv(void);  
  
int intlev=0x0f;  /* interrupt level associated with IRQ7 */  
void interrupt far (*oldfunc)();  
int int_occurred=FALSE;  /* Note global definitions */  
  
int main(void)  
{  
   int first=FALSE;  
   int secs, msecs;  
   int status_byte;
   struct timeb t1, t2;  
   long loops = 0L;

   status_byte = inportb(STATUS);
   printf("status=0x%02x\n",status_byte);
   open_intserv();  
   outportb(CONTROL, inportb(CONTROL) | 0x10);  
   /* set bit 4 on control port (irq enable) to logic one */  
   while(!kbhit())  
   {  
      ++loops;
      if (int_occurred)  
      {  
         int_occurred=FALSE;  
         status_byte = inportb(STATUS);
         if (first==FALSE)  
         /* if this is the first interrupt, just fetch the time */  
         {  
            loops = 0L;
            ftime(&t2);  
            first=TRUE;  
         }  
         else  
         {  
            t1=t2;  /* otherwise, save old time, fetch new */  
            ftime(&t2);  /* and compute difference */  
            secs=t2.time - t1.time;  
            msecs=t2.millitm - t1.millitm;  
            if (msecs<0)  
            {  
              --secs;  
              msecs=msecs+1000;  
           }  
           printf("Elapsed time is %d (%ld) [status=0x%02x]\n",
                  1000*secs+msecs,loops,status_byte);  
           loops = 0L;
           }  
        }  
     }  
     close_intserv();  
     return(0);  
  }  
  
  void interrupt far intserv(void)  
  /* This is written by the user.  Note that the source of the interrupt  
  /* must be cleared and then the PC 8259 cleared (int_processed).  
  /* must be included in this function.  
  /*******/  
  {  
     disable();  
     int_processed();  
     int_occurred=TRUE;  
     enable();  
  }  
  
  void open_intserv(void)  
  /* enables IRQ7 interrupt.  On interrupt (low on /ACK) jumps to intserv.  
  /* all interrupts disabled during this function; enabled on exit.  
  /*******/  
  {  
     int int_mask;  
     disable();  /* disable all ints */  
     oldfunc=getvect(intlev);  /* save any old vector */  
     setvect(intlev, intserv);  /* set up for new int serv */  
     int_mask=inportb(0x21);    /* 1101 1111 */  
     outportb(0x21, int_mask & ~0x80);  /* set bit 7 to zero */  
                                /* -leave others alone */  
     enable();  
  }  
  
  void close_intserv(void)  
  /* disables IRQ7 interrupt */  
  {  
     int int_mask;  
     disable();  
     setvect(intlev, oldfunc);  
     int_mask=inportb(0x21) | 0x80;  /* bit 7 to one */  
     outportb(0x21,int_mask);  
     enable();  
  }  
  
  void int_processed(void)  
  /* signals 8259 in PC that interrupt has been processed */  
  {  
     outportb(0x20, 0x20);  
  }  
 
