#!/usr/local/bin/perl
#
#   Make IR codes for memo entry
#

$text = shift(@ARGV);

print STDERR "'$text'\n";

$MAX_CHARS = 13;

$text =~ s/[\n\r]+$//;
$text =~ s/[\t]//g;
$text = substr($text, 0, $MAX_CHARS);
$fmt = "%-" . "$MAX_CHARS" . "s";
$text = sprintf($fmt, $text);

$UPPER = 1;
$LOWER = 2;
$OTHER = 3;
#                1  2  3  4  5  6  7  8  9  0
$upper_keys = '   ABCDEFGHIJKLMNOPRSTUVWXYQZ';
$lower_keys = '   abcdefghijklmnoprstuvwxyqz';
$other_keys = '1  2  3  4  5  6  7  8  9  0';

#{"0101001", 'd', "disc",    "select disc", "*", "Select disc by no. [CAPS]"},
#{"1101001", 't', "track",   "select track","*", "Select track by no. [SPACE]"},
#{"0011001", 'g', "group",   "select group","*", "Select group by no. [DEL}"},
$CAPS = 'd';
$SPACE = 't';
$DEL = 'g';
$ENTER = 'e';
$PREFIX = 'm';
$SUFFIX = $ENTER;

$ir = $PREFIX;
$ref = '|';
$FILLER = "=";
$state = $UPPER;
for ($ix = 0; $ix < length($text); ++$ix) {
	$ch = substr($text, $ix, 1);
	$next_state = $state;

	# find key in on of the tables
	$key = 0;
	$key_times = 0;
	if ($ch eq ' ') {
		$ir .= $SPACE;
		$ref .= ' ';
	} elsif (($i = index($upper_keys, $ch)) >= 0) {
		$next_state = $UPPER;
		$key = int($i / 3) + 1;
		$key_times = $i % 3 + 1;
	} elsif (($i = index($lower_keys, $ch)) >= 0) {
		$next_state = $LOWER;
		$key = int($i / 3) + 1;
		$key_times = $i % 3 + 1;
	} elsif (($i = index($other_keys, $ch)) >= 0) {
		$next_state = $OTHER;
		$key = int($i / 3) + 1;
		$key_times = $i % 3 + 1;
	} else {
		print STDERR "Bad key: $ch\n";
		$ir .= $SPACE;
		$ref .= ' ';
	}
	$key = $key % 10;
	##print "$ch: $key $key_times ($state -> $next_state)\n";

	$case_times = 0;
	if      (($state == $UPPER) && ($next_state == $LOWER)) {
		$case_times = 1;
	} elsif (($state == $UPPER) && ($next_state == $OTHER)) {
		$case_times = 2;
	} elsif (($state == $LOWER) && ($next_state == $UPPER)) {
		$case_times = 2;
	} elsif (($state == $LOWER) && ($next_state == $OTHER)) {
		$case_times = 1;
	} elsif (($state == $OTHER) && ($next_state == $UPPER)) {
		$case_times = 1;
	} elsif (($state == $OTHER) && ($next_state == $LOWER)) {
		$case_times = 2;
	}

	$filler = $ch;
	for ($i = 0; $i < $case_times; ++$i) {
		$ir .= $CAPS;
		$ref .= $filler; $filler = $FILLER;
	}
	for ($i = 0; $i < $key_times; ++$i) {
		$ir .= "$key";
		$ref .= $filler; $filler = $FILLER;
	}
	if ($key != 0 && $ix < length($text) - 1) {
		$ir .= $ENTER;
		$ref .= $filler; $filler = $FILLER;
	}
	$state = $next_state;
}
$ir .= $SUFFIX;
$ref .= '|';

print STDERR "$ref\n";
print "$ir\n";
