
sub print_packet  {
    local($buf) = @_ ;

    print "\n",&ctime," port $port length ",length($buf),"\n\n" ;
    &hexdump($buf,"  ") ;
}

sub hexrow  {
    local($buf,$i,$c,$hex,$asc) = @_ ;

    for ($i=0 ; $i<length($buf) ; $i++)  {
        $c = unpack("C",substr($buf,$i,1)) ;
        $hex .= sprintf(" %02X",$c) ;
        $c = unpack("C",'.') if ($c < 0x20 || $c >= 127) ;
        $asc .= pack("C",$c) ;
    }
    printf "%-48s  %s\n",$hex,$asc ;
}

sub hexdump  {
    local($buf,$sp,$i,$off) = @_ ;
    local($BPR) = 16 ;

    for ($i=0 ; $i<length($buf) ; $i+=$BPR)  {
        printf "$sp%04X  ",$i ;
        &hexrow(substr($buf,$i,$BPR)) ;
    }
}

sub ctime  {
    ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) =
        localtime(time) ;
    sprintf("%04d/%02d/%02d %02d:%02d:%02d",$year+1900,$mon+1,$mday,$hour,
        $min,$sec) ;
}

sub inet_addr  {
    local($addr,@x) = @_ ;

    (@x) = split(/\./,$addr) ;
    pack("C4",@x) ;
}

1 ;
