#! /usr/local/bin/perl

$base='c:/avrfirm/samples/sonycd/sonycd';

$dumb_perl = 0;
$unlink_works = 0;

$image_width = 150;
$image_height = 150;

$password = 'maniac';

$cd_player = "$base/send200";

$title = "Sony CD Changer";

$cd_dir = "$base/cddb";
$cd_url = "cddb";
$gif_dir = 'images';
$action_url = 'sonycd.cgi';

$play_gif = "$gif_dir/play2.gif";
##$play_gif = "$gif_dir/skullt.gif";
##$play_gif = "http://192.245.227.1/images/skullt.gif";
$stop_gif = "$gif_dir/stop2.gif";
$detail_gif = "$gif_dir/detail1.gif";
$delete_gif = "$gif_dir/delete1.gif";
$new_gif = "$gif_dir/new1.gif";
$cd_gif = "$gif_dir/cd1.gif";

$detail_marker = "<IMG SRC=\"$detail_gif\" border=1>";
$play_marker = "<IMG SRC=\"$play_gif\" border=1>";
$stop_marker = "<IMG SRC=\"$stop_gif\" border=1>";

$heading = "&nbsp $title&nbsp&nbsp<A HREF=\"$action_url?stop=1\">$stop_marker</A>";
$heading .= "&nbsp <A HREF=\"$action_url?status=1\"><b>?</b></A>";

$table_heading='<table border=1 cellpadding=2 cellspacing=0>';
$bgcolor1 = '6699cc';
$bgcolor2 = 'dcdcdc';

$date = &loctime(time);
$remote_addr = $ENV{'REMOTE_ADDR'};

$asof = "as of $date";
$asof = '';

sub check_remote_host {
	$ok = 0;
	$ok = 1 if ($remote_addr =~ /^127\.0\.0\.1$/);		# local host
	$ok = 1 if ($remote_addr =~ /^10\./);			# MFT internal
	$ok = 1 if ($remote_addr =~ /^192\.245\.227\./);	# MFT internal
	$ok = 1 if ($remote_addr =~ /^205\.230\.17\.34$/);	# fido
	$ok = 1 if ($remote_addr =~ /^206\.71\.186\.98$/);	# ceberus
	###$ok = 0;
	$ok = 2 if ($values{'password'} eq $password);
	return $ok;
}

$query = $ENV{'QUERY_STRING'};
###print "<br>QUERY_STRING = \"$query\"<br>\n";

sub my_do_header {
	local($type, $size) = @_;

	print "Content-length: $size\n" if ($size);
	print "Content-type: $type\n\n";
}

sub read_tstamps {
	if ($ts_file ne '') {
		if (open(TS, "<$ts_file")) {
			while (<TS>) {
				$ts = $_;
				$ts =~ s/[\s\r\n]//g;
				next if ($ts =~ /^$/);
				++$old_tstamps{$ts};
			}
			close(TS);
		}
	}
}

sub write_tstamps {
	if ($ts_file ne '') {
		if (open(TS, ">$ts_file")) {
			foreach $ts (sort (keys %tstamps))  {
				print TS "$ts\n";
			}
			close(TS);
		}
	}
}

@q = split(/[&]/, $query);
foreach $s (@q) {
	##print "$s<br>\n";
	($key, $val) = split(/[=]/, $s);
	next if ($key =~ /[.]y/);
	$key =~ s/[.]x$//;
	if ($key =~ /^play_(.*)$/) {
		$val = $1;
		$key =~ s/_.*//;
	}
	$values{$key} = $val;
	##print "$key $val\n";
}

sub check_for_local {
	$ok = &check_remote_host;
	if (!$ok) {
		###&my_do_header('text/html', 0);
		print "<html>\n";
		print "<head>\n";
		print "<title>$title Access Denied</title>";
		print "</head>\n";
		print "<body>\n";
		print "<h3>";
		print "<IMG SRC=\"$cd_gif\" align=\"left\">";
		print "$title Access Denied";
		print "</h3>";
		print "Access from host $remote_addr denied!\n";
		###print "<FORM METHOD=\"GET\" ACTION=\"$action_url\" ENCTYPE=\"application/x-www-form-urlencoded\">\n";
		###print "Password: <INPUT TYPE=\"text\" NAME=\"password\" VALUE=\"$p\" SIZE=8 MAXLENGTH=20>\n" if (!$trusted_host);
		###print "<INPUT TYPE=\"submit\" VALUE=\"Retry\">\n";
		print "</body>\n";
		print "</html>\n";
		exit;
	}
}

###&read_tstamps;

&my_do_header('text/html', 0);

if ($values{'loop'} ne '') {
	$n = $values{'loop'};
	$s = "$action_url?$query";
	$s =~ s/loop=\d+/loop=$n/;
	print <<EOF
<META HTTP-EQUIV="REFRESH" CONTENT="$n;
URL=$s">
EOF
	;
}

if ($values{'play'} ne '') {
	&check_for_local;
	$disc = $values{'play'};
	($disc, $track) = split('_', $disc);
	print "Playing disc $disc track $track<br>\n";
	print "<pre>\n";
	($cmd = "$cd_player  play_dt $disc $track") =~ s/\//\\/g; print "$cmd\n"; system($cmd);
	print "\n";
	print "</pre>\n";
	($cmd = "$cd_player mode") =~ s/\//\\/g; $s = `$cmd`;
	if ($s =~ /mode disc\s+(\d+)\s+track\s+(\d+)\s+(.*)/) {
		$disc = $1;
		$track = $2;
		$mode = $3;
		&disc2id($disc);
		$file = "$cd_dir/ids/$id";
		&show_tracks($disc, $track, $id, "Changer status: $mode\n");
	} else {
		print "Status failed!<br>\n";
		print "<pre>\n";
		print "$cmd\n";
		print $s;
		print "</pre>\n";
	}
	exit;
}

if ($values{'stop'} ne '') {
	&check_for_local;
	print "Stopping play...<br>\n";
	print "<pre>\n";
	($cmd = "$cd_player stop") =~ s/\//\\/g; print "$cmd\n"; system($cmd);
	print "\n";
	($cmd = "$cd_player mode") =~ s/\//\\/g; print "$cmd\n"; system($cmd);
	print "</pre>\n";
	exit;
}

if ($values{'status'} ne '') {
	&check_for_local;
	($cmd = "$cd_player mode") =~ s/\//\\/g; $s = `$cmd`;
	if ($s =~ /mode disc\s+(\d+)\s+track\s+(\d+)\s+(.*)/) {
		$disc = $1;
		$track = $2;
		$mode = $3;
		&disc2id($disc);
		$file = "$cd_dir/ids/$id";
		&show_tracks($disc, $track, $id, "Changer status: $mode\n");
	} else {
		print "Status failed!<br>\n";
		print "<pre>\n";
		print "$cmd\n";
		print $s;
		print "</pre>\n";
	}
	exit;
}

if ($values{'details'} ne '') {
	$disc = $values{'details'};
	$track = $values{'track'};
	$id = $values{'id'};
	$file = "$cd_dir/ids/$id";
	&show_tracks($disc, $track, $id, '');
}

print <<EOF

<HTML>
<HEAD>
<TITLE>$title</TITLE>
</HEAD>

<H2><IMG SRC="$cd_gif" align="left">$heading$asof</H2>

<FORM METHOD="GET" ACTION="$action_url" ENCTYPE="application/x-www-form-urlencoded">

<P>
$table_heading
<tr bgcolor=$bgcolor1>
<th colspan=7>$title Contents</th>
</tr>

<tr bgcolor=$bgcolor2>
<th>Disc</th>
<th>Play</th>
<th>Details</th>
<th>Artist</th>
<th>Title</th>
<th>Category</th>
<th>CD ID</th>
</tr>

EOF
;

sub get_files {
	local($dir) = @_;
	local($files, @files);

	if ($dumb_perl) {
		$files = `ls $dir`;
		$files =~ s/[\r\n]/ /g;
		@files = split(/\s+/, $files);
	} else {
		if (opendir(D,"$dir"))  {
			@files = readdir(D);
			closedir(D);
		} else {
			print "<tr><th>opendir on $dir failed!</tr>\n";
		}
	}
	return @files;
}

sub get_artist_title {
	local($s) = @_;

	if ($s =~ /^\s*(.+)\s+[\/]\s+(.*)/) {
		return ($1, $2);
	}
	if ($s =~ /^\s*(.+)\s+[-]+\s+(.*)/) {
		return ($1, $2);
	}
	$s =~ s/[\r\n]//g;
	return ($s, '');
}

sub disc2id {
	local($disc) = @_;

	$file = sprintf("$cd_dir/%03d.dsc", $disc);
	$artist = '&nbsp';
	$dtitle = '&nbsp';
	$cat = '&nbsp';
	$id = '&nbsp';
	if (open(F, "<$file")) {
		while (<F>) {
			$s = $_;
			$s =~ s/[\r\n]//g;
			$n = @F = split('\s\/\s', $s);
			if ($n > 0) {
				$artist = $F[0];
				$dtitle = $F[1];
				$cat = $F[2];
				$id = $F[3];
	                        $dtitle = '&nbsp' if ($dtitle eq '');
	                        $artist = '&nbsp' if ($artist eq '');
	                        $cat = '&nbsp' if ($cat eq '');
	                        $id = '&nbsp' if ($id eq '');
			} else {
				$dtitle = $s;
			}
		}
		close(F);
	}
}

{
	@files = &get_files($cd_dir);
	foreach $file (@files)  {
		next if ($file !~ /.dsc$/i);
		$key = $file;
		##print "<tr><th>$file $key</tr>\n";
		$list{$key} = $file;
	}
	$ix = 0;
	foreach $key (sort {$a cmp $b;} (keys %list))  {
		++$ix;
		$file = $list{$key};
		$fname = $file;
		$disc = $fname; $disc =~ s/[.].*//; $disc =~ s/^0+//;
		&disc2id($disc);
		$href = "$cd_url/$fname";
		$details = "$cd_url/ids/$id";
		$track = 1;
		$s = $disc . '_' . $track;

##<td align=center><INPUT TYPE="image" NAME="play_$s" SRC="$play_gif" border=1></td>
##<td align=center><INPUT TYPE="submit" NAME="play_$s" VALUE=$s></td>
		print <<EOF
<tr>
<td align=center>$disc.</td>
<td align=center><A HREF="$action_url?play=$s\&id=$id">$play_marker</A></td>
<td align=center><A HREF="$action_url?details=$disc\&id=$id">$detail_marker</A></td>
<td align=left>$artist</td>
<td align=left>$dtitle</td>
<td align=center>$cat</td>
<td align=center><A HREF="$details">$id</A></td>
</tr>

EOF
		;
	}
}
###&write_tstamps;

	print <<EOF
</table>
$ix discs total<br>

<P><b>Remote Host: $remote_addr</b>
</BODY>
</HTML>
EOF
;

sub loctime {
	($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(@_[0]);								
	$monx = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec')[$mon];
	$wdayx = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat')[$wday];
	# Wed, 25 Feb 1998 22:05:53 GMT
	if ($hour == 12) {
		$pm = 'PM';
	} elsif ($hour == 0) {
		$hour += 12;
		$pm = 'AM';
	} elsif ($hour > 12) {
		$hour -= 12;
		$pm = 'PM';
	} else {
		$pm = 'AM';
	}
	return sprintf("%s, %d %s %d %02d:%02d:%02d %s",$wdayx,$mday,$monx,$year+1900,$hour,$min,$sec,$pm);
}	

sub my_gmtime  {
	($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) =
		gmtime(@_[0]);
	$monx = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec')[$mon];
	$wdayx = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat')[$wday];
	# Wed, 25 Feb 1998 22:05:53 GMT
	return sprintf("%s, %d %s %d %02d:%02d:%02d GMT",$wdayx,$mday,$monx,$year+1900,$hour,$min,$sec);
}

sub show_tracks {
	local($disc, $detail_track, $id, $extra) = @_;
	local($file, $extd, $extts, %extts, $extt);
	local($ttitles, %ttitles, $track, $dtitle, $artist);

	$file = "$cd_dir/ids/$id";
	$extd = $extra;
	$dtitle = '';
	if (open(F, "$file")) {
		# DISCID=b909f20d,bd09f20d,c109f20d,c609f40d
		# DTITLE=Jimmy Buffett / Songs You Know by Heart
		# TTITLE0=Cheeseburger in Paradise
		# TTITLE1=He went to Paris
		# TTITLE2=Fins
		# EXTT0=Barometer Soup\n\nFollow in my wake \nYo
		# EXTD=(+) Produced by Jim Gaines and Stevie Ray Vaughan 
		while (<F>) {
			$s = $_;
			$s =~ s/[\r\n]//g;
			if ($s =~ /^DTITLE=\s*(.*)$/) {
				$dtitle .= $1;
			}
			if ($s =~ /^TTITLE(\d+)=(.*)$/) {
				$track = $1;
				$ttitle = $2;
				$ttitles[$track] = $ttitle;
			}
			if ($s =~ /^EXTT(\d+)=(.*)$/) {
				$track = $1;
				$extt = $2;
				$extts[$track] .= $extt;
			}
			if ($s =~ /^EXTD=(.*)$/) {
				$extd .= $1;
			}
		}
		close(F);
		($artist, $dtitle) = &get_artist_title($dtitle);
		&emit_track_table;
	} else {
		print "<pre>\n";
		print "Can't open disc $disc ID file $file\n";
		print "</pre>\n";
	}
	exit;
}

sub emit_track_table {
	$image = '';
	if ($detail_track == 0) {
		$jpg_file = "$cd_dir/ids/$id.jpg";
		$jpg_url = "$cd_url/ids/$id.jpg";
		if ( -f $jpg_file) {
			$image = "<img src=\"$jpg_url\" align=\"right\" width=\"$image_width\" height=\"$image_height\">";
			$image = "<A HREF=\"$jpg_url\">$image</A>";
		}
		$s = "$action_url";
		$x = "changer";
	} else {
		$s = "$action_url?details=$disc&id=$id";
		$x = "disc";
	}
	$back = "<A HREF=\"$s\"><b>$x</b><br><br></A>";
	print <<EOF

<HTML>
<HEAD>
<TITLE>Disc $disc: $artist / $dtitle</TITLE>
</HEAD>

<H2><IMG SRC="$cd_gif" align="left">$heading$asof&nbsp$back</H2>

<FORM METHOD="GET" ACTION="$action_url" ENCTYPE="application/x-www-form-urlencoded">

<P>
$image
$table_heading
<tr bgcolor=$bgcolor1>
<th colspan=4>Disc $disc: $artist / $dtitle</th></tr>

<tr bgcolor=$bgcolor2>
<th>Track</th>
<th>Play</th>
<th>Details</th>
<th>Title&nbsp
<A HREF="$cd_url/ids/$id">($id)</A>
</th>
</tr>

EOF
	;

	$track = 0;
	foreach $ttitle (@ttitles)  {
		++$track;
		next if ($detail_track > 0 && $track != $detail_track);
		if ($extts[$track-1] ne '') {
			$details = "<A HREF=\"$action_url?details=$disc\&id=$id&track=$track\">$detail_marker</A>";
			$extra = '';
			if ($detail_track > 0) {
				$extra = $extts[$detail_track-1];
				##$extra =~ s/\\n/\n<br>/g;
				##$details = "$extra";
				$extra =~ s/\\n/\n/g;
				$extra =~ s/\\t/\t/g;
				$extra = "<pre>\n$extra\n</pre>\n";
				$details = "<A HREF=\"$cd_url/ids/$id\">$id</A>";
			}
		} else {
			$details = '&nbsp';
		}
		##printf("%6d.  %s\n", $track, $ttitle);
		$s = $disc . '_' . $track;

##<td align=center><INPUT TYPE="image" NAME="play_$s" SRC="$play_gif" border=1></td>
		print <<EOF
<tr>
<td align=center>$track.</td>
<td align=center><A HREF="$action_url?play=$s\&id=$id">$play_marker</A></td>
<td align=center>$details</td>
<td align=left>$ttitle</td>
</tr>

EOF
		;
	}
	if ($detail_track == 0 && $extd ne '') {
		$extra = $extd;
		$extra =~ s/\\n/\n/g;
		$extra =~ s/\\t/\t/g;
		$extra = "<pre>\n$extra\n</pre>\n";
	}

	print <<EOF
</table>
$extra
<P><b>Remote Host: $remote_addr</b><br>
</BODY>
</HTML>
EOF

	;
}

1;
