#!/usr/local/bin/perl
#

$debug = 0;

$ip = "10.4.0.226";
$socks = "-s 10.4.0.1";

$httpget = "httpget -d $socks";
$httpget = "httpget $socks";

##$send = "send200";
$send = "perl query.pl -w -ip $ip";
$cddb_dir = "./cddb";
$cddb_id_dir = "$cddb_dir/ids";

#
# For list: http://www.cddb.com/hits/stats.html#sites
#
###$url = "http://cddb.moonsoft.com/~cddb/cddb.cgi?";
##$url = "http://www.cddb.com/cgi-bin/cddb.cgi?";
##$url = "http://freedb.freedb.org:80/~cddb/cddb.cgi?";
##$url = "http://freedb.freedb.org/cgi-bin/cddb.cgi?";
##$url = "http://www.real.com/query.html?";
##$url = "http://cddb.sonic.net/~cddb/cddb.cgi?";

##$url = "http://cddb.cddb.com/~cddb/cddb.cgi?";
##$url = "http://cddb.cddb.com:80/~cddb/cddb.cgi?";
$url = "http://freedb.freedb.org/~cddb/cddb.cgi?";

select((select(STDOUT), $| = 1)[0]);	# unbuffer output
select((select(STDERR), $| = 1)[0]);	# unbuffer output

while ($ARGV[0] =~ /^-/) {
	$opt = shift;
	print "$opt\n";
	if ($opt eq '-d') {
		$debug = 1;
	} else {
		print STDERR "$0 unknown option ($opt)!\n";
		exit(1);
	}
}

#
# player 0: mode disc 6 track 0 scanning one_disc
#
$cmd = "$send mode";
print "cmd: $cmd\n" if ($debug);
$result = `$cmd`;
$result =~ s/[\r\n]$//;
if ($result =~ /\sdisc\s+(\d+)\s/) {
	$disc = $1;
} else {
	print "$cmd failed! ($result)\n";
	exit(1);
}
print "disc $disc\n" if ($debug);

#
# player 0: disc_info disc 6 index 1 trk 11 len 47:00 frame 8
#
$cmd = "$send query_disc $disc";
print "cmd: $cmd\n" if ($debug);
$result = `$cmd`;
$result =~ s/[\r\n]$//;
if ($result =~ /\strk\s+(\d+)\s+len\s+(\d+)[:](\d+)\s+frame\s+(\d+)/) {
	$tracks = $1;
	$mins = $2;
	$secs = $3;
	$frame = $4;
} else {
	print "$cmd failed! ($result)\n";
	exit(1);
}
$tot_secs = 60 * $mins + $secs;
print "disc $disc has $tracks tracks len $mins:$secs ($tot_secs secs) frame $frame\n";

#
# player 0: track_info disc 6 trk 1 len 03:34
#
$ts = 0;
for ($trk = 0; $trk < $tracks; ++$trk) {
	$t = $trk + 1;
	$cmd = "$send query_track $disc $t";
	print "cmd: $cmd\n" if ($debug);
	$result = `$cmd`;
        $result =~ s/[\r\n]$//;
	if ($result =~ /\strk\s+(\d+)\s+len\s+(\d+)[:](\d+)/) {
		$mins = $2;
		$secs = $3;
	} else {
		print "$cmd failed! ($result)\n";
		exit(1);
	}
	$trk_secs[$trk] = 60 * $mins + $secs;
	$ts += $trk_secs[$trk];
	print "  $t $mins:$secs ($trk_secs[$trk])\n";
}
$id = &CDDB_Disc_ID($tot_secs, *trk_secs, $tracks);
$id_hex = sprintf("%08x", $id);
print "CDDB Disc ID: $id_hex (playtime $ts sec)\n";

$oops = 1;
$s = '';
($real_id, $cat, $artist, $title) = &lookup_disc_id($id_hex);
if ($id ne '') {
	$s = &lookup_disc_info($real_id, $cat);
	print "Disc $disc...\n";
	if ($s =~ /TITLE/) {
		$ss = $s;
		while ($ss =~ s/([DT])TITLE[^=]*=(.*)//) {
			$t = $2;
			print "\t" if ($1 eq 'T');
			print "$t\n";
		}
		if (! -d $cddb_dir) {
			print STDERR "Creating CDDB directory $cddb_dir\n";
			mkdir($cddb_dir, 0777);
		}
		$file = "$cddb_id_dir/$real_id";
		if (! -d $cddb_id_dir) {
			print STDERR "Creating CDDB ID directory $cddb_id_dir\n";
			mkdir($cddb_id_dir, 0777);
		}
		$file = "$cddb_id_dir/$id_hex";
		if (!open(DBFILE, ">$file")) {
			print STDERR "Can't write to CDDB ID file $file!\n";
		} else {
			print DBFILE $s;
			close(DBFILE);
		}
		$file = sprintf("$cddb_dir/%03d.dsc", $disc);
		if (!open(DBFILE, ">$file")) {
			print STDERR "Can't write to CDDB file $file!\n";
		} else {
			print DBFILE "$artist / $title / $cat / $id_hex\n";
			close(DBFILE);
		}
		$oops = 0;
	} else {
		print $s;
	}
}

if ($oops) {
	$file = sprintf("$cddb_dir/%03d.dsc", $disc);
	$artist = '????';
	$title = '????';
	$cat = '????';
	$id_hex = '????????';
	if (!open(DBFILE, ">$file")) {
		print STDERR "Can't write to CDDB file $file!\n";
	} else {
		print DBFILE "$artist / $title / $cat / $id_hex\n";
		print DBFILE "$s";
		close(DBFILE);
	}
}

sub CDDB_Disc_ID {
	local($tot_secs, *trk_secs, $tracks) = @_;
	local($toc, $frame, $i, $n, $StartTime, $playtime, $tottime);
	
	$tottime = $tot_secs;
	$playtime = 0;
	for ($i = 0; $i < $tracks; $i++) {
		$playtime += $trk_secs[$i];
	}

	# calculate TOC size since we can't read it
	$StartTime = 2;		# !!!!!!!!!!!!! kludge !!!!!!!!!!!!
	$toc = $StartTime = $tottime - $playtime;
print "$StartTime = $tottime - $playtime\n";

	$n = 0;

	# For backward compatibility this algorithm must not change
	for ($i = 0; $i < $tracks; $i++) {
		$n += &CDDB_sum($StartTime);
		$StartTime += $trk_secs[$i];
	}

	# cddb query discid ntrks off1 off2 ... nsecs
	$frame = $toc * 75;
	$cddb_query = "$tracks";
	for ($i = 0; $i < $tracks; $i++) {
		$cddb_query .= sprintf("+%d", $frame);
		$frame += $trk_secs[$i] * 75;
	}
	$cddb_query .= "+$playtime";

	return ((($n % 0xff) << 24) | ($playtime << 8) | $tracks);
}


sub CDDB_sum {
	local($n) = @_;
	local($ret);

	# For backward compatibility this algorithm must not change
	$ret = 0;
	while ($n > 0) {
		$ret += $n % 10;
		$n = $n / 10;
	}
	return $ret;
}

sub get_artist_title {
	local($s) = @_;
	local($artist, $title);

	if ($s =~ /^\s*(.+)\s+[\/]\s+(.*)/) {
		$artist = $1;
		$title = $2;
	} elsif ($s =~ /^\s*(.+)\s+[-]+\s+(.*)/) {
		$artist = $1;
		$title = $2;
	} elsif ($s =~ /^\s*(.+)[\/](.*)/) {
		$artist = $1;
		$title = $2;
	} else {
		$s =~ s/[\r\n]//g;
		$artist = $s;
		$title = '';
	}
	$artist =~ s/\//-/g;
	$title =~ s/\//-/g;
	return ($artist, $title);
}

#
# 200 rock f00f1b10 Fleetwood Mac / Greatest Hits
#
# 211 Found inexact matches, list follows (until terminating `.')
# rock 5909cf08 Lynyrd Skynyrd / Gold & Platinum (disc 2)
# rock 5b09cf08 Lynyrd Skynyrd / Gold & Platinum
# .
#
sub lookup_disc_id {
	local($id) = @_;
	local($cddb_cmd, $parms, $cmd, $x);
	local($new_id, $category, $artist, $title);

	$cddb_cmd = "cddb+query+$id+$cddb_query";
	$parms = "cmd=$cddb_cmd".'&hello=lightner+lightner.net+xcmd+2.1&proto=1';
	$socks = '';
	##$socks = "-s 192.245.227.138";
	$cmd = "$httpget $socks \"$url$parms\"";
	##$cmd = "$httpget $socks '$url$parms'";
	print "$cmd\n";
	print "$cmd\n" if ($debug);
	$x = `$cmd`;
	print "$x\n" if ($debug);
	if ($x =~ /^200\s+(\S+)\s+([0-9a-zA-Z]+)\s+(.*)/) {
		$category = $1;
		$new_id = $2;
		($artist, $title) = &get_artist_title($3);
		print "$category: $artist / $title ($id)\n";
	} elsif ($x =~ /^211\s+/) {
		@F = split('\n', $x);
		$x = $F[1];	# pick first
		if ($x =~ /^\s*(\S+)\s+([0-9a-zA-Z]+)\s+(.*)/) {
			$category = $1;
			$new_id = $2;
			($artist, $title) = &get_artist_title($3);
		}
	}
	return ($new_id, $category, $artist, $title);
}

sub lookup_disc_info {
	local($id, $cat) = @_;
	local($cddb_cmd, $parms, $cmd, $x);

	$cddb_cmd = "cddb+read+$cat+$id";
	$parms = "cmd=$cddb_cmd".'&hello=lightner+lightner.net+xcmd+2.1&proto=1';
	$socks = '';
	###$socks = "-s 192.245.227.138";
	$cmd = "$httpget $socks \"$url$parms\"";
	##$cmd = "$httpget $socks '$url$parms'";
	print "$cmd\n" if ($debug);
	$x = `$cmd`;
	print "$x\n" if ($debug);
	return $x;
}
