/*
 * Program SEND.C
 *
 * Send commands to Sony CD Changer
 */

#include <stdio.h>
#include <bios.h>
#include <dos.h>
#include <sys\timeb.h>

#define DATA 0x0378
#define STATUS DATA+1
#define CONTROL DATA+2

#define TRUE 1
#define FALSE 0

float factor = 1 / 1.6;

static int delay_usecs(long usecs) {
	long i, num;
	int data;

	num = usecs * factor;
	for (i = 0; i < num; ++i) {
		data = inportb(DATA);
	}
	return data;
}

#define PP_OUT_BIT	7	/* PC parallel port output bit */

static void setbit(int ch) {
	if (ch & 1) {
		outportb(DATA, 0 << PP_OUT_BIT);
	} else {
		outportb(DATA, 1 << PP_OUT_BIT);
	}
}

static long unit_delay = 600;	/* unit delay in usecs (space bit) */

void send_command(char *p)
{
	int ch;

	/* start bit */
	disable();
	setbit(0);
	delay_usecs(4 * unit_delay);
		setbit(1);
		delay_usecs(unit_delay);

	while ((ch = *p++) != 0) {
		setbit(0);
		delay_usecs(unit_delay);
		if (ch == '1') {
			delay_usecs(unit_delay);
		}
		setbit(1);
		delay_usecs(unit_delay);
	}
	setbit(1);
	enable();
}

int main(int argc, char **argv)
{
	char *p;

	--argc; ++argv;
        if (!argc) {
		fprintf(stderr, "usage: test \"00101010\"\n");
		exit(1);
	}

#if 0
	printf(".");
	delay_usecs(1000000L);
	printf(".\n");
#endif

	p = *argv;
	printf("%ld: %s\n", unit_delay, p);

	send_command(p);

	return 0;
}
