/*
* Program READ_INT.C
*

Uses interrupt service routine to note interrupt from printer port.
The interrupt is caused by a negative on /ACK input on Printer Port.

*/

#include <stdio.h>
#include <bios.h>
#include <dos.h>
#include <sys\timeb.h>

#define DATA 0x0378
#define STATUS DATA+1
#define CONTROL DATA+2

#define TRUE 1
#define FALSE 0

void open_intserv(void);
void close_intserv(void);
void int_processed(void);
void interrupt far intserv(void);

int intlev=0x0f;  /* interrupt level associated with IRQ7 */
void interrupt far (*oldfunc)();
int int_occurred=FALSE;  /* Note global definitions */
long loops = 0L;

#define SHORT_WAIT 1000L
#define LONG_WAIT  3000L
#define THRESHOLD  500L

long wait_change(long max) {
   int last;
   long i;

   last = inportb(STATUS);
   for (i = 0; i < max; ++i) {
      if (last != inportb(STATUS)) return i;
   }
   return -1L;
}

static int console_break = 0;

static int break_handler(
void
){
   ++console_break;
   return(1);
}

static char queue[20000];
static char *pqueue = queue;

static void read_bits(void) {
#  define MAX_BITS 100
   int i, num;
   long wait, stat, stats[MAX_BITS];

   num = 0;
   wait = LONG_WAIT;
   while(1) {
      stat = wait_change(wait);
      wait = SHORT_WAIT;
      if (stat < 0) break;
      stats[num++] = stat;
      if (num >= MAX_BITS) break;
   }
   for (i = 1; i < num; i += 2) {
      *pqueue++ = (stats[i] > THRESHOLD) ? '1' : '0';
   }
   *pqueue++ = '\n';
}

int main(void)
{
   ctrlbrk(break_handler) ;    /* install our own ^C/BREAK handler */
   open_intserv();
   /* set bit 4 on control port (irq enable) to logic one */
   outportb(CONTROL, inportb(CONTROL) | 0x10);
   while(!console_break && !kbhit()) {
      if (*pqueue) printf("%c", *pqueue++);
   }
   close_intserv();
   return(0);
}

void interrupt far intserv(void)
/* This is written by the user.  Note that the source of the interrupt
/* must be cleared and then the PC 8259 cleared (int_processed).
/* must be included in this function.
/*******/
{
   disable();
   read_bits();
   int_processed();
   int_occurred=TRUE;
   enable();
}

void open_intserv(void)
/* enables IRQ7 interrupt.  On interrupt (low on /ACK) jumps to intserv.
/* all interrupts disabled during this function; enabled on exit.
/*******/
{
   int int_mask;
   disable();  /* disable all ints */
   oldfunc=getvect(intlev);  /* save any old vector */
   setvect(intlev, intserv);  /* set up for new int serv */
   int_mask=inportb(0x21);    /* 1101 1111 */
   outportb(0x21, int_mask & ~0x80);  /* set bit 7 to zero */
                              /* -leave others alone */
   enable();
}

void close_intserv(void)
/* disables IRQ7 interrupt */
{
   int int_mask;
   disable();
   setvect(intlev, oldfunc);
   int_mask=inportb(0x21) | 0x80;  /* bit 7 to one */
   outportb(0x21,int_mask);
   enable();
}

void int_processed(void)
/* signals 8259 in PC that interrupt has been processed */
{
   outportb(0x20, 0x20);
}

