#--------------------------- httpd.pl --------------------------
#! /usr/local/bin/perl
#
#   "Cheap" HTTPD for Windows 95/NT (or even "unix"es).
#
#   usage: start /minimized inetd 80 "perl httpd.pl"
#
close(STDERR) ;
#open(STDERR,">/etc/httpd.log") ;
open(STDERR,">/dev/null") ;
%CONTENT = (                # file-type to content-type mapping table.
    'txt','text/plain',        # this is the default
    'html','text/html',
    'htm','text/html',
    'jpg','image/jpeg',
    'gif','image/gif',
    'zip','application/zip',
    'mid','audio/x-midi',
    'wav','audio/x-wav',
    'exe','application/dos-executable'
) ;

%SITE_MAP = (                # host name to base directory mapping table
    'www.manxclub.com',    '/http/manxclub',    # alternate
    'manxclub.com',        '/http/manxclub',    # alternate
    'freyder.com',           '',          # use default
    'www.freyder.com',       '',          # use default
    'www.lightner.com',      '',          # use default
    'lightner.com',          '',          # use default
    'www.lightner.net',      '',          # use default
    'lightner.net',          '',          # use default
    'www.helland.net',       '/web/helland',  # alternate
    'manitowishwaters.net',       '/web/manito',  # alternate
    'www.manitowishwaters.net',   '/web/manito',  # alternate
    'greerspier.com',        '/web/greer',    # alternate
    'www.greerspier.com',    '/web/greer',    # alternate
    '', ''
) ;

$server = 'Cheap-HTTPD/1.3.1' ;
$http = ($ARGV[0] ne "" ? $ARGV[0] : "x:/htdocs") ;
$link_suffix = ".lnk" ;
$max_links = 32 ;           # max link nesting before we give up
$links_to_cgi = 1 ;         # TRUE if links to cgi scripts are OK
$dynamic_links = 1 ;        # TRUE if links can be PERL code
$log = 1 ;
binmode(STDOUT) ;
$NL = "\n" ;
#print "Connection from ".$ENV{"CONNECTION"}.$NL ;
$connection = $ENV{"CONNECTION"} ;
if ($connection eq "")  {   # must be Unix
    $peer = `getpeername` ;
    $sock = `getsockname` ;
    ($remport,$remhost,$localhost,$localport) = split(/[ \n]+/,$peer.$sock) ;
    $connection = "$remhost $remport $localhost $localport" ;
# make it look like it would if coming from windows inetd
    $ENV{"CONNECTION"} = $connection ;
}
else  {
    ($remhost,$remport,$localhost,$localport) = split(/ /,$connection) ;
}
print STDERR "Session PID $$ ".&filetime(time)." from $remhost:$remport\n" ;

$get_line = '';
$target_host = '';
$log = 0 ;
while (<STDIN>)  {
    print STDERR if ($log) ;
    s/[\r\n]//g ;
    if ($_ eq "")  {
        last ;
    }
    if (/^get/i)  {
        $get_line = $_;
    }
    if (/^Host[:]\s*(\S+)/i)  {
        $target_host = $1;
    }
}

if ($get_line ne '') {
    ($cmd,$url) = split(/ +/,$get_line) ;
    ($targ_lower = $target_host) =~ tr/[A-Z]/[a-z]/ ;
    $s = $SITE_MAP{$targ_lower};
    $http = $s if ($s ne '');
    $url =~ s=\.\.[/\\]=/=g ;           # ../ -> /
    if (substr($url,0,1) ne "/")  {
        $url = "/".$url ;
    }
    if ($url =~ /[\\\/]$/)  {	# removing trailing slash
	$has_slash = 1;
        chop $url ;
    } else {
        $has_slash = 0;
    }
    #
    # if it looks like a cgi script, then strip the arguments off of
    # the URL name before we traverse it.
    #
    if ($url =~ /(([^?]*\/cgi\-bin\/[^?]+)|(.*\.cgi))/i)  {
        $script_name = $1 ;
        $cgi_args = substr($url, length($script_name)+1) ;
        $url = $script_name ;           # isolate URL
#        print STDERR "CGI=$url ARGS=$cgi_args\n" ;
        $cgi = 1 ;
    }
    else  {
#        print STDERR "URL=$url\n" ;
        $cgi = 0 ;
    }
    $parent = "" ;
    $parent = $1 if ($url =~ /(.*\/)[^\/]+$/) ;
#    print STDERR "Parent \"$parent\"\n" ;
    $filename = "$http$url" ;
    if (!(-e $filename))  {             # can't find full name
        &traverse_url($url) ;           # look harder
    }
    if (-d _)  {
#        print STDERR "Directory $filename\n" if ($log) ;
        if (!$has_slash) {   # special response if URL missing trailing slash
            $new_url = "http://$target_host$url/" ;
            &start_header("HTTP/1.0 302 Found") ;
            print "Location: $new_url\n" ;
            print "Content-type: text/html\n\n" ;
            print "<HEAD><TITLE>Document moved</TITLE></HEAD>\n" ;
            print "<BODY><H1>Document moved</H1>\n" ;
            print "This document has moved <A HREF=\"$new_url\">here</A>.</BODY>\n" ;
            last ;
	}
        if (-r "$filename/index.html")  {
            $filename .= "/index.html" ;
        } elsif (-r "$filename/index.htm")  {
            $filename .= "/index.htm" ;
        } else  {
            &do_header('text/html',0) ;
            &dodir() ;
            last ;
        }
    }
#    print STDERR "Sending $filename\n" if ($log) ;
    if ($cgi && ($filename ne ""))  {           # CGI script
        $ENV{"QUERY_STRING"} = $cgi_args ;
        $ENV{"SERVER_SOFTWARE"} = $server ;
        $ENV{"REMOTE_ADDR"} = $remhost ;
        $ENV{"REMOTE_PORT"} = $remport ;
        $ENV{"SERVER_ADDR"} = $localhost ;
        $ENV{"SERVER_PORT"} = $localport ;
        $ENV{"SCRIPT_NAME"} = $script_name ;
        if ($cgi_args ne "")  {         # arguments to handle
            (@xargs) = split(/\&/,$cgi_args) ;   # split it
            foreach $arg (@xargs)  {    # for each one
                $arg =~ s/\%([0-9a-z][0-9a-z])/pack(C,hex($1))/ieg ;
                ($es,$ev) = split(/=/,$arg) ;
                $Q{$es} = $ev ;     # put into environment
            }
        }
        &do_header('',0) ;
        $| = 1 ;
print "----------- $filename -----------\n";
        require "$filename" ;
    }
    elsif ($filename && open(F,"<$filename"))  {
        binmode(F) ;
        $ctype = "" ;
        if ($filename=~/\.([^.]+)$/) {
            ($ctype=$1) =~ tr/[A-Z]/[a-z]/ ;
        }
        &do_header((defined $CONTENT{$ctype}) ? $CONTENT{$ctype} :
            $CONTENT{'txt'},-1) ;
        print while (<F>) ;
        close(F) ;
    } else  {
      print STDERR "Can't open $url\n" if ($log) ;
      print "HTTP/1.0 404 Object Not Found\n" ;
      print "Content-type: text/html\n\n" ;
      print "<BODY><h1>HTTP/1.0 404 Object Not Found</h1></BODY></html>\n" ;
    }
}
exit(0);

sub filetime  {
    ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) =
        localtime(@_[0]) ;
    sprintf("%04d/%02d/%02d %02d:%02d:%02d",$year+1900,$mon+1,$mday,$hour,$min,$sec) ;
}

sub gmtime  {
    ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) =
        gmtime(@_[0]) ;
    $monx = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec')[$mon];
    $wdayx = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat')[$wday];
    # Wed, 25 Feb 1998 22:05:53 GMT
    return sprintf("%s, %d %s %d %02d:%02d:%02d GMT",$wdayx,$mday,$monx,$year+1900,$hour,$min,$sec) ;
}

sub dodir  {
    undef %what ;
    if (open(A,"<$filename/.what"))  {
        while (<A>)  {
            next if (substr($_,0.1) eq "#") ;
            chop ;
            ($file,$desc) = split(/[ \t]+/,$_,2) ;
            $what{$file} = $desc ;
        }
        close(A) ;
    }
    if (opendir(D,"$filename"))  {
        @files = readdir(D) ;
        closedir(D) ;
        print "<html><head><title>Directory of $url/</title></head><body><pre>$NL" ;
        print "<h1>Directory of $url/</h1>$NL$NL" ;
        if ($parent)  {
            print "<A HREF=\"$parent\">Parent directory</A>$NL" ;
        }
        $max_fnlen = 0 ;
        foreach $file (@files)  {
            $fnlen = length($file) ;
            $max_fnlen = $fnlen if ($fnlen>$max_fnlen) ;
        }
        foreach $file (sort @files)  {
            next if (substr($file,0,1) eq ".") ;
            if ($file =~ /$link_suffix$/i) {  # link?
                if (($lfile = &get_link("$filename/$file")) ne "")  {
                    (@stats) = stat($lfile) ;
                    $file =~ s/${link_suffix}$//i ;
                }
            }
            else  {
                (@stats) = stat($filename."/".$file) ;
            }
            $ftime = &filetime($stats[9]) ;
            $dir = "" ;
            if (-d _)  {
                $file .= '/' ;
                $fsize = "Directory" ;
            }
            else  {
                $fsize = $stats[7] ;
                $fsize =~ s/^(\d+)(\d\d\d)(\d\d\d)(\d\d\d)$/\1,\2,\3,\4/ ;
                $fsize =~ s/^(\d+)(\d\d\d)(\d\d\d)$/\1,\2,\3/ ;
                $fsize =~ s/^(\d+)(\d\d\d)$/\1,\2/ ;
                $fsize .= " bytes" ;
            }
            $fname = "<A HREF=\"$url/$file\">$file</A>" ;
            $fnlen = length($file) ;
            $ffmt = sprintf("%%s%%-%ds %%17s  %%s%%s$NL",
                $max_fnlen-$fnlen+2) ;
            printf STDOUT $ffmt,$fname,' ',$fsize,$ftime,
                ((defined $what{$file}) ? "  $what{$file}" : "") ;
        }
        print "$NL</pre></body></html>$NL" ;
        next ;
    }
}

sub start_header {
    local($response) = @_ ;

    (@stats) = stat($filename) ;
    $ftime = &filetime($stats[9]) ;
    $fsize = $stats[7] ;
    $ftime = &gmtime($stats[9]) ;
    $now = &gmtime(time) ;
    print "$response\n" ;
    print "Date: $now\n" ;
    print "Server: NCSA/1.4.2\n" ;
    ####print "Server: $server\n" ;
}

sub do_header {
    local($type, $size) = @_ ;

    &start_header("HTTP/1.0 200 Document follows") ;
    print "Date: $now\n" ;
    print "Server: NCSA/1.4.2\n" ;
    ####print "Server: $server\n" ;
    if (0) {
    	print 'ETag: "3421d78-9a6a-34fb8ee7"'."\n";
    	print 'Accept-Ranges: bytes'."\n";
    }
    if ($size < 0) {
        print "Last-modified: $ftime\n" ;
        print "Content-length: $fsize\n" ;
    } elsif ($size > 0) {
        print "Content-length: $size\n" ;
    }
    print "Content-type: $type\n\n" if ($type ne '') ;
}

sub html_header  {
    print "HTTP/1.0 200 OK\nContent-type:text/html\n\n<HTML><PRE>\n" ;
}

sub text_header  {
    print "HTTP/1.0 200 OK\nContent-type:text/plain\n\n" ;
}

sub get_link  {
    local($filename,$linkname,*L) = @_ ;

    if (!($filename =~ /$link_suffix$/i))  {
        $filename .= $link_suffix ;
    }
#    print STDERR "Testing link $filename\n" ;
    open(L,"<$filename") || return "" ;
    $linkname = scalar(<L>) ;
    chop $linkname ;
    close(L) ;
    if ($dynamic_links && (substr($linkname,0,1) eq "#"))  {
        eval substr($linkname,1,9999) ;
    }
#    print STDERR "$filename -> $linkname\n" ;
    $linkname ;
}

sub traverse_url  {
    $filename = $http ;                 # start in the "root"
    $parent = "" ;
    $last_parent = "/" ;
#    print STDERR "Dirs=",join("/",@dirs),"\n" ;
    $links = 0 ;
    (@dirs) = split(/\//,$url) ;        # separate the directory paths
    shift @dirs ;
    while ($name = shift @dirs)  {
#        print STDERR "Checking $filename for $name\n" ;
        $filename .= "/$name" ;
        $parent = $last_parent ;
        (@stats) = stat("$filename") ;
        if (!(-d _))  {                 # not a directory
#            print STDERR "$filename not directory.\n" ;
            if (-r _)  {                # readable - normal file
#                print STDERR "$filename is readable\n" ;
            }
            elsif (($linkname = &get_link($filename)) ne "")  {    # a link!
                if (++$links > $max_links)  {  # too many links
                    undef $filename ;
                    last ;
                }
#                print STDERR "$filename.link -> $linkname\n" ;
                $filename = $linkname ;
                if (!(-d $filename))  {     # link to a non-directory
#                    print "$filename is not a directory.\n" ;
                    last ;              # we be done
                }
            }
            else  {                     # oh my - we're going to lose
                undef $filename ;
                last ;
            }
        }
        $last_parent .= "/$name" ;
    }
    if ($#dirs != -1)  {                # didn't scan all paths
        undef $filename ;
    }
#    printf STDERR "Traverse result is \"%s\"\n",$filename ;
    $parent =~ s=^//=/= ;               # more / kludges
}
