#!/usr/local/perl

#####################################################################
$delete_only = 0;
$cd_dir = "./cddb";
$show_cmd = "perl show.pl";
###$show_cmd = "show.bat";

$start_disc = 1;        # starting disc
$end_disc = 0;        # 0 = do all discs

##$start_disc = 130; ######################################
##$end_disc = $start_disc + 1; ########################################

$max_to_check = 210;            # max. no. discs to check
#####################################################################

select((select(STDOUT), $| = 1)[0]);    # unbuffer output
select((select(STDERR), $| = 1)[0]);    # unbuffer output

&delete_extra if ($delete_only);

# start with first disc
&step_next;
$s = &do_cmd("send200 mode", 1);

# loop thru all discs
while (1) {
    # find out what's playing now
    $done = 0;
    while ($done == 0) {
        print ".";
        $s = &do_cmd("send200 mode", 1);
        if ($s =~ /\sdisc (\d+)/) {
            $disc = $1;
            $s = &do_cmd("send200 query_disc $disc", 1);
            if ($s =~ /\sdisc_info\s/) {
                $done = 1;
                last;
            }
        }
        sleep(2);
    }
    print "\n";

    # stop if we've come full circle
    last if ($disc == $first_disc);

    # check for CDDB data locally
    $last_disc_checked = $disc;
    if (&disc2id($disc) == 0) {
        print "----------------- new disc -------------------\n";
    } else {
        unlink($idfile);
    }

    # update local database with CDDB info
    $cmd = $show_cmd;
    print "$cmd\n"; system($cmd);
    if (&disc2id($disc) == 0) {
        # second try
        print "$cmd\n"; system($cmd);
    }

    # remember first disc
    $first_disc = $disc if ($first_disc == 0);

    last if ($disc == $end_disc);

    # step to next disc
    &step_next;
    $s = &do_cmd("send200 mode", 1);
    sleep(5);
}
print "Ended at disc $last_disc_checked";
&do_cmd("send200 stop", 1);
exit 0;

sub step_next {
    local($s, $file, $cmd);

    # step to next disc
    while (1) {
        ++$disc;
        $disc = 1 if ($disc > 200);
        $s = &do_cmd("send200 play_dt $disc 1", 0);
        last if ($s !~ /\sno_disc\s/);
        $file = &disc2file($disc);
        $cmd = "unlink($file)";
        print "deleting $file\n";
        unlink($file);
    }
}

sub disc2file {
    local($disc) = @_;
    local($file);

    $file = sprintf("$cd_dir/%03d.dsc", $disc);
    return $file;
}

sub disc2id {
    local($disc) = @_;
    local($n, $s, @X, %X) = @_;

    $file = &disc2file($disc);
    $artist = '';
    $dtitle = '';
    $cat = '';
    $id = '';
    $idfile = '';
    $hasid = 0;
    if (open(F, "<$file")) {
        while (<F>) {
            $s = $_;
            $s =~ s/[\r\n]//g;
            $n = @X = split('\s\/\s', $s);
            if ($n > 0) {
                $artist = $X[0];
                $dtitle = $X[1];
                $cat = $X[2];
                $id = $X[3];
            } else {
                $dtitle = $s;
            }
        }
        close(F);
        $idfile = "$cd_dir/ids/$id";
        $hasid = 1 if (-f $idfile);
    }
    return $hasid;
}

sub do_cmd {
    local($cmd, $quiet) = @_;
    local($s);

    ###$quiet = 0;
    print STDERR "cmd: $cmd\n" if (!$quiet);
    $s = `$cmd`;
    if (!$quiet) {
        print STDERR "resp: $s";
        print STDERR "\n" if ($s eq '');
    }
    return $s;
}

sub delete_extra {
    &step_next;
    while (1) {
        &step_next;
        # remember first disc
        $first_disc = $disc if ($first_disc == 0);
        last if ($disc == $end_disc);
    }
    &do_cmd("send200 stop", 1);
    exit 0;
}

