/*
 *   post.c - Post WM_USER+msg_num message to a named window
 *            Lists all active windows by name if run with no parameters
 */

#include <windows.h>
#include <stdio.h>
#include <string.h>

static char *sFmt   = "%6d  %8d  %s  (%s)\n";
static char *sTitle = "%6s  %8s  %s\n";
static int all = 0;
static char *program;
static char *wname;
static int msg_num;
static int debug = 0;
static int list = 0;
static int found = 0;
static DWORD wparm;
static DWORD lparm;


Err(char *why)
{
	LPVOID lpMsgBuf;

	FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
    		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		GetLastError(),
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL );
	fprintf(stderr, "%s: %s", why, lpMsgBuf);
	LocalFree( lpMsgBuf );
}

static WINAPI
EnumProc(
	HWND hWindow,
	void *pvParam
){
	char sTitle[256];
	char sClass[256];
	unsigned long Pid;

	strcpy(sClass, "???");
	GetWindowThreadProcessId(hWindow,&Pid);
	GetWindowText(hWindow,sTitle,sizeof sTitle-1);
	if (!all && sTitle[0] == 0) 
		return(TRUE);
	GetClassName(hWindow,sClass,sizeof sClass-1);
	if (sTitle[0] == 0)
		strcpy(sTitle, "???");
	if (sClass[0] == 0)
		strcpy(sClass, "???");
	if (list) {
		printf(sFmt, hWindow, Pid, sTitle, sClass);
	} else {
		if (!_stricmp(sTitle, wname)) {
			if (debug) {
				printf(
				"PostMessage(%d, WM_USER + %d, %d, %d)\n",
				hWindow, msg_num, (int)wparm, (int)lparm);
			}
			if (!PostMessage(hWindow, WM_USER + msg_num,
					(WPARAM)wparm, (LPARAM)lparm)) {
				Err("PostMessage() failure");
				exit(1);
			}
			++found;
		}
	}
	return(TRUE);
}

usage(char *program)
{
	fprintf(stderr,
		"usage: %s [/d] \"window name\" msg_num [[wparm] [lparm]]\n"
		"       %s [/d]\n",
		program, program);
	exit(1); 
}

main(int argc, char **argv)
{
	char *p;

	program = *argv;
	--argc, ++argv;

	p = strrchr(program, '\\');
	if (!p)
		p = strrchr(program, '/');
	if (p)
		program = p + 1;

	while (argc && (**argv == '-' || **argv == '/')) {
		if (!_stricmp(*argv, "-d")) {
			debug = 1;
		} else if (!_stricmp(*argv, "/d")) {
			debug = 1;
		} else {
			usage(program);
		}
		--argc, ++argv;
	}

	if (argc == 0) {
		list = 1;
	} else {

		wname = *argv;
		--argc, ++argv;

		if (argc < 1) usage(program);
		msg_num = atoi(*argv);
		--argc, ++argv;

		if (argc > 0) {
			wparm = atoi(*argv);
			--argc, ++argv;
		}

		if (argc > 0) {
			lparm = atoi(*argv);
			--argc, ++argv;
		}
	}

	EnumWindows(EnumProc, 0);
	if (!found) {
		fprintf(stderr, "Can't find window named \"%s\"!\n", wname);
		return(1);
	} else {
		return(0);
	}
}
